<?php
/* show_posts.php : Shows the posts.
// this is the file you need to embed into your website. Please use the integration wizard.
// renaming this file to something other than show_posts.php will make ShoutCode fail !
// http://korn19.ch/coding/shoutcode
*/

do{
$path =  __FILE__;
$path = preg_replace("'\\\show_posts\.php'", '', $path);
$path = preg_replace("'/show_posts\.php'", '', $path);
$has_posted = false; $utf8_error = false;

$files = array('data/posts', 'inc/functions', 'inc/post_functions', 'data/template', 'data/settings', 'data/ip', 'data/flood_db');
foreach($files as $check_file){
	if(!file_exists($path.'/'.$check_file.'.php')){
		echo '/'.$check_file.' does not exist! Halting ShoutCode.';
		break 2;
	}
	include_once($path.'/'.$check_file.'.php');
}

function return_setting($input){
	global $sc_usr_stngs;
	if(isset($sc_usr_stngs[$input])){
		return (bool)$sc_usr_stngs[$input];
	}
	else{
		echo '$sc_usr_stngs['.$input.'] does not exist!';
	}
}

if(isset($_POST['post'])){ // user wants to post.
	do{
	if(isset($ip_ban) && count($ip_ban) > 0){
		foreach($ip_ban as $ip_check){
			$ip_check = str_replace('.', '\\.', $ip_check);
			if(preg_match('/^'.str_replace('*', '[0-9]{1,3}', $ip_check).'$/', $_SERVER['REMOTE_ADDR'])){
				echo '<b style="color: #f00">You have been banned from posting!</b>';
				break 2;
			}
		}
	}
	
	if(utf8_strlen(trim($_POST['name'])) < 3 || utf8_strlen(trim($_POST['message'])) < 3){
		echo 'Sorry, but both name and message have to be bigger than 3 characters!';
		break;
	}
	$mail = trim($_POST['mail']);
	if(strlen($mail) > 0){
		if(return_setting('allow_email')){
			if(preg_match('/^[a-z0-9]+[a-z0-9\?\.\+-_]*@[a-z0-9_-]+(\.[a-z0-9_-]+)*\.[a-z]+$/', $mail)){
				$mail_type = 'mail';
			}
		}
		if(!isset($mail_type)){
			if(preg_match('/(http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/', $mail)){
				$mail_type = 'link';
			}
			else{
				echo 'ShoutCode detected that your input for mail or URL matched neither URL nor e-mail. Please ensure that your input is a valid link OR e-mail address.';
				break;
			}
		}
	}
	else{
		unset($mail);
	}

  
	if(!is_writable($path.'/data/posts.php')){
		echo '<span style="color: #900">Error: /data/posts.php is not writable!</span>';
		break 2;
	}
	$mail = change_input($mail);
	$message = $_POST['message'];
	if(utf8_strlen($message) > 500){
		echo 'Your message must be at least 4 characters long and it may not exceed 500 characters!';
	}
	$message = change_input($message);
// dbl post & flood activation
	if($sc_usr_stngs['flood_wait'] > 1){
		if(isset($flood[$_SERVER['REMOTE_ADDR']])){
			if(time() - $flood[$_SERVER['REMOTE_ADDR']] < $sc_usr_stngs['flood_wait']){
				echo '<b>Flood activation enabled! Please wait ';
				echo $sc_usr_stngs['flood_wait'] - (time() - $flood[$_SERVER['REMOTE_ADDR']]).' seconds.</b>';
				break;
			}
		}
		$flood[$_SERVER['REMOTE_ADDR']] = time();
		foreach($flood as $ip => $time){
			if(time() - $time > $sc_usr_stngs['flood_wait']){
				unset($flood[$ip]);
			}
		}

	}

	if(return_setting('stop_dblpost')){
		if(isset($dbl_md5) && isset($dbl_md5[$_SERVER['REMOTE_ADDR']])){
			if(md5($message) == substr($dbl_md5[$_SERVER['REMOTE_ADDR']], 0, 32)){
				echo '<b style="color: #f00">You already have posted the exact same message!</b>';
				break;
			}
		}
		foreach($dbl_md5 as $ip => $item){ // a little housekeeping.
			if(time() - substr($item, 32) > 30*60){ // if record is older than 30 minutes
				unset($dbl_md5[$ip]);
			}
		}
		$dbl_md5[$_SERVER['REMOTE_ADDR']] = md5($message).time();
	}
	if(return_setting('stop_dblpost') || $sc_usr_stng['flood_wait'] > 1){
		$openlog = fopen($path.'/data/flood_db.php', 'w');
		fwrite($openlog, '<'.'?php $flood = '.var_export($flood, 1).'; $dbl_md5 = '.var_export($dbl_md5, 1).'; ?'.'>');
		fclose($openlog);
	}
//// end
	$name = trim($_POST['name']);
	if(utf8_strlen($name) > 35){
		echo 'Your name may not exceed 30 characters';
		break;
	}
	$name = change_input($name);

	if($utf8_error == true){
		echo '<b>Error! Please send your messages only in UTF-8!</b>';
		break;
	}

# prepare to write to DB
	if(!isset($posts) || !is_array($posts)){
		$posts = array();
	}
	array_unshift($posts, array($message, $name, $mail, $_SERVER['REMOTE_ADDR'], time()));
	$openlog = fopen($path.'/data/posts.php', 'w');
	fwrite($openlog, '<'.'?php $posts = '.var_export($posts, 1).'; ?'.'>');
	fclose($openlog);
	echo '<span style="color: #090">Thanks for posting!</span>';

	$openlog = fopen($path.'/data/count-cache.php', 'w');
	fwrite($openlog, count($posts));
	fclose($openlog);
	$has_posted = true;
	} while(0);
}
# Display posts.

if(isset($number) && is_numeric($number)){
	if($number > 2 && $number < 51){
		$news_per_page = $number;
	}
	else{
		echo '<br /><b>Warning</b>: $number not in valid range [3-50].';
		$news_per_page = 15;
	}
}
else{
	$news_per_page = 15;
}

$total = count($posts);
if($total == 0){
	echo 'There are no posts.';
}
else{
	$total_pages = ceil($total/$news_per_page);
	$page = 1;
	if(isset($_GET['page'])){
		$page = $_GET['page'];
		if(!preg_match('/^[1-9]{1}[0-9]{0,}$/', $page)){
			$page = 1;
		}
		else{
			if($page > $total_pages || $page < 1){
				$page = 1;
			}
		}
	}
	
	$skip_posts = ($page-1)*$news_per_page;
	$temp_count = $display_count = 0;
	foreach($posts as $post){
		if($temp_count < $skip_posts){
			$temp_count++;
		}
		else{ // display post!
			if($display_count >= $news_per_page){
				break;
			}
			$output = $template[0];
			if(isset($post[2]) && strlen($post[2]) > 3){
				if(strpos($post[2], '@') !== false){
					if(return_setting('post_email')){
						$output = str_replace('{author-link}', '<a href="mailto:'.$post[2].'">'.$post[1].'</a>', $output);
					}
					else{
						$output = str_replace('{author-link}', $post[1], $output);
					}
				}
				else{
					$output = str_replace('{author-link}', '<a href="'.$post[2].'">'.$post[1].'</a>', $output);
				}
			}
			else{
				$output = str_replace('{author-link}', $post[1], $output);
			}
			$post[0] = smilies($post[0]);
			if(return_setting('allow_bbcode')){
				$output = str_replace('{post}', bbcode($post[0]), $output);
			}
			else{
				$output = str_replace('{post}', $post[0], $output);
			}
			
			if(!isset($sc_usr_stngs['time_offset'])){
				$sc_usr_stngs['time_offset'] = 0;
			}
			
			$output = str_replace('{time}', date('d M Y, H:i', (int)$post[4] + $sc_usr_stngs['time_offset']), $output);
			echo $output;
			$display_count++;
		}
	}
}

if($has_posted === false){
// prepare for smilies
	$data = '';
	if(count($sc_usr_stngs['smilies']) > 0 && isset($sc_usr_stngs['smilies_path'])){
		echo '<script type="text/javascript">
//<!--
	function insertext(text){
		document.scform.message.value+=" "+ text;
		document.scform.message.focus();
        }
//-->
</script>
<noscript>You do not have JavaScript enabled and will have to enter smilies manually!</noscript>';
		foreach($sc_usr_stngs['smilies'] as $smiley){
			$data .= ' <a href="javascript:insertext(\':'.$smiley.':\', \'short\')"><img src="'.$sc_usr_stngs['smilies_path'].$smiley.'.gif" alt="'.$smiley.'" style="border: 0" /></a>';
		}
		$template[1] = str_replace('{smilies}', $data, $template[1]);
	}
	else{
		$template[1] = str_replace('{smilies}', 'No smilies.', $template[1]);
	}
	echo "\r".'<form action="'.$_SERVER['PHP_SELF'].'" method="post" name="scform" accept-charset="utf-8">'.$template[1].'</form>';
}

if($total_pages > 1){
	echo '<p>Page: ';
	for($i = 1; $i <= $total_pages; $i++){
		if($page == $i){
			echo '<b>'.$i.'</b> ';
		}
		else{
			echo '<a href="?page='.$i.'">'.$i.'</a> ';
		}
	}
	echo '</p>';
}
} while(0);
?>
<!-- Shoutbox by ShoutCode: http://korn19.ch/coding/shoutcode -->