<?php
if(!$functions_included){ die('Direct viewing of file prohibited'); }
deny_access(__FILE__);
if(!check_login()){ die('Not logged in!'); }
echo_style('Managing Posts', 1);
/*$posts = array(
            array(0 => 'data', 1 => 'name', 2 => 'mail/url', 3 => IP, 4 => time()),
);*/
if(!file_exists('./data/posts.php')){ die('Could not find /data/posts.php'); }
require('./data/posts.php'); // get $posts
require('./inc/post_functions.php');
require('./data/settings.php');
if(!isset($posts)){
	die('There aren\'t any posts in the database right now.');
}
$amount_posts = count($posts);
if($amount_posts <= 0){
	die('There currently aren\'t any posts in the database.');
}
if(is_writable('./data/count-cache.php')){
	$openlog = fopen('./data/count-cache.php', 'w');
	fwrite($openlog, $amount_posts);
	fclose($openlog);
}

$num_per_page = 25;
if(isset($_POST['number'])){
	$num_temp = $_POST['number'];
}
else if(isset($_GET['number'])){
	$num_temp = $_GET['number'];
}
if(isset($num_temp)){
	if(!preg_match('/[^0-9]/', $num_temp) && $num_temp < 100 && $num_temp > 2){
		$num_per_page = $num_temp;
	}
	unset($num_temp);
}

echo '<form action="'.$_SERVER['PHP_SELF'].'" method="post">
<table>
 <tr>
   <td>Posts per page:</td>
   <td><input type="text" name="number" style="width: 50px" maxlength="2" value="'.$num_per_page.'" /></td>
   <td><input type="submit" class="submit" value="Go" /><input type="hidden" name="do" value="posts" /></td>
 </tr>
</table></form>';

$amount_pages = ceil($amount_posts/$num_per_page);
if(isset($_GET['page']) && preg_match('/^[0-9]$/', $_GET['page'])){
	$page = $_GET['page'];
	if($page > $amount_pages || $page < 1){
		$page = 1;
	}
}
else{
	$page = 1;
}
echo '<form action="'.$_SERVER['PHP_SELF'].'" method="post">
<input type="hidden" name="do" value="process" />
<table class="posts">
<tr><th style="width: 50px">Delete</th><th>Name</th><th>Message</th><th>Mail/URL</th><th style="width: 70px">Options</th><th>Date posted</th></tr>';

if(!isset($sc_usr_stngs['time_offset'])){
	$sc_usr_stngs['time_offset'] = 0;
}

$start_from = ($page-1)*$num_per_page;

$count_skip = 0; $count_display = 0;
foreach($posts as $key => $post){
	if($count_skip < $start_from){
		$count_skip++;
	}
	else if($count_display < $num_per_page){
		if($count_display%2 == 0){
			$color = '#fff';
		}
		else{
			$color = '#ddf';
		}
		if($post[3] == $_SERVER['REMOTE_ADDR']){
			$color = '#fdd';
		}
  		echo "\r".'<tr style="background-color: '.$color.'">
			<td style="text-align: center"><input class="small" type="checkbox" name="item[]" value="'.$key.'" />
			<td>'.$post[1].'</td><td>';
			$post[0] = smilies($post[0]);
			if($sc_usr_stngs['allow_bbcode']){
				echo bbcode($post[0]);
			}
			else{
				echo $post[0];
			}
			echo '</td>
			<td>'.$post[2].'</td>
<td><a href="?do=find&amp;ip='.$post[3].'"><img src="./data/find.png" alt="Find" title="Find posts made by this IP" /></a>
 <a href="?do=ip&amp;get='.$post[3].'"><img src="./data/block.png" alt="Block" title="Ban this IP address" /></a>
 <a href="http://network-tools.com/default.asp?prog=trace&host='.$post[3].'"><img src="./data/world.png" alt="Location" title="Find from where this IP comes from" /></a>
</td>
			<td>'.date('d M Y, H:i', (int)$post[4] + $sc_usr_stngs['time_offset']).'</td>
			</tr>';
		$count_display++;
	}
	else{
		break;
	}
}
echo '</table><p><input type="submit" value="Delete selected posts" /></p>
</form>';

// pagination
echo '<p>Go to page:';
$i = 1;
while($i <= $amount_pages){
	if($i == $page){
		echo ' <span class="pagebx"><b>'.$i.'</b></span>';
	}
	else{
		echo ' <span class="pagebx"><a href="?do=posts&amp;page='.$i.'&amp;number='.$num_per_page.'">'.$i.'</a></span> ';
	}
	$i++;
}
echo '<br /><br />&raquo; Posts made by your current IP ('.htmlentities($_SERVER['REMOTE_ADDR']).') are highlighted in light red.</p>';
?>