<?php
error_reporting(E_ALL ^ E_NOTICE);
if(!$functions_included){
	die('Direct viewing of file prohibited');
}
deny_access(__FILE__);
if(isset($_GET['page'])){
	$page = $_GET['page'];
}
else if(isset($_POST['page'])){
	$page = $_POST['page'];
}
else{
	$page = 1;
}
if(!preg_match('/^[1-4]{1}$/', $page)){
	$page = 1;
}

if($page == 1){

// Step 1: Say hello
	echo_style('Welcome');
	echo 'This page will guide you through the installation of <a href="http://korn19.ch/coding/shoutcode">ShoutCode</a>.
		<br />ShoutCode is a PHP-powered shoutbox script.<br />
<form action="'.$_SERVER['PHP_SELF'].'" method="post">
<p style="margin-left: 20px">
<input type="hidden" name="page" value="2" />
<input type="submit" value="Install ShoutCode &gt; &gt;" /></p>
</form>';
}
if($page == 2){

// Step 2: Check files - if writable and/or exists
	echo_style('Checking files...');
	echo 'Checking if files exist and if they are writable (when necessary):<ul>';
	function check_files($file){
		global $sc_filestat;
		if(file_exists($file)){
			$sc_filestat = array('1' => is_writable($file), '2' => decoct(fileperms($file)));
			return true;
		}
		else{
			$sc_filestat = array('1' => 0);
			return false;
		}
	}
	$files_to_check = array( // 0 - folder; 1 - file; 2 - writable file
	'show_posts.php' => 1,
	'style.css' => 1,
	'./mdu' => 0,
	'./mdu/login.php' => 1,
	'./mdu/options.php' => 1,
	'./mdu/process.php' => 1,
	'./mdu/templates.php' => 1,
	'./mdu/posts.php' => 1,
	'./mdu/main.php' => 1,
	'./mdu/settings.php' => 1,
	'./mdu/about.php' => 1,
	'./mdu/find.php' => 1,
	'./mdu/bbcode.php' => 1,
	'./mdu/ip.php' => 1,
	'./inc' => 0,
	'./inc/users.db.php' => 2,
	'./inc/functions.php' => 1,
	'./inc/post_functions.php' => 1,
	'./data' => 0,
	'./data/posts.php' => 2,
	'./data/count-cache.php' => 2,
	'./data/settings.php' => 2,
	'./data/template.php' => 2,
	'./data/ip.php' => 2,
	'./data/flood_db.php' => 2,
	);
	$errors = false;
	foreach($files_to_check as $file_name => $options){
		echo '<li><b>'.$file_name.'</b>: ';
		if($options == 2){
			if(!check_files($file_name, true)){
				$errors = true;
				if($sc_filestat[1] == 0){
					echo '<span style="color: #f00">File does not exist</span>';
				}
				else{
					echo '<span style="color: #f00">File not writable! (CHMOD: '.$sc_filestat[2].')</span>';
				}
			}
			else{
				echo 'File existent &amp; writable.';
			}
		}
		else if($options == 1 || $options == 0){
			if($options == 1){ echo 'File'; }
			else if($options == 0){ echo 'Folder'; }
			if(file_exists($file_name)){ echo ' exists.'; }
			else{ echo '<span style="color: #f00"> does not exist!</span>'; $errors = true; }
		}
		echo '</li>';
	}
	echo '</ul>';
	if($errors){
		echo '<p>There have been errors found when doing the file check. Please note the comments that are in red 
		and fix these before proceeding with the installation.</p>';
	}
	else{
		echo '<p>Everything is fine! Click on the proceed button to continue</p>
<form action="'.$_SERVER['PHP_SELF'].'" method="post">
<p style="margin-left: 20px"><input type="hidden" name="page" value="3" />
<input type="submit" value="Proceed &gt; &gt; " /></p>
</form>';
	}
}
if($page == 4){

// Step 4: Validate input from step 3
// and finish the setup
$exp = "/^[a-z0-9]+[a-z0-9\?\.\+-_]*@[a-z0-9_-]+(\.[a-z0-9_-]+)*\.[a-z]+$/";
if(isset($_POST['details']) && count($_POST['details']) == 4){
	$details = $_POST['details']; $error = '';
	foreach($details as $num => $detail){
		if(strlen($detail) < 2 || strlen($detail) > 25){
			if($num == 3 && strlen($detail) > 2){ continue; } // let it pass
			else{
				$error = '<br /><span style="color: #f00">User name and password have to be at least 3 characters long and not longer than 25 characters.</span>';
				unset($details[$num]);
			}
		}
	}

	if(isset($details[0]) && preg_match('/[^a-z0-9-_]/i', $details[0])){ // username
		$error .= '<br /><span style="color: #f00">Invalid characters in user name.</span> Please provide a user name with only letters and numbers.';
		unset($details[0]);
	}
	if(isset($details[1]) && preg_match('/[^a-z0-9-_]/i', $details[1])){ // pass
		$error .= '<br /><span style="color: #f00">Invalid characters in password.</span> Please provide a password with only letters and numbers.';
		unset($details[1]); unset($details[2]);
	}
	if(isset($details[1]) && convert_pass($details[1]) !== convert_pass($details[2])){
		$error .= '<br /><span style="color: #f00">The password did not match the re-typed password.</span>';
		unset($details[1]); unset($details[2]);
	}
	if(isset($details[3]) && !preg_match($exp, $details[3])){
		$error .= '<br /><span style="color: #f00">ShoutCode has detected that you did not enter a valid e-mail address!</span>';
		unset($details[3]);
	}
	if($error != ''){ $page = 3; }

	if($page == 4){
		echo_style('Finishing installation');
		echo '<br /><span style="color: #040">Thank you! Now writing to the user database</span>';

		if(is_writable('./inc/users.db.php')){ // 0 = pwd; 1 = perm; 2 = regdate; 3 = lastlogin; 4 = mail; 5 = postnum
			$users = array(strtolower($details[0]) => array(0 => convert_pass($details[2]), 1 => 1, 2 => time(), 3 => 'Never', 4 => $details[3]), 5 => 0);
			$openlog = fopen('./inc/users.db.php', 'w');
			fwrite($openlog, '<'.'?php $users = '.var_export($users, true).' ?'.'>');
			fclose($openlog);
		}
		else{
			die('/inc/users.db.php not writable!!! <form action="'.$_SERVER['PHP_SELF'].'" method="post">
			<input type="submit" value="Re-run installation &gt; &gt;" /></form>');
		}
		if(is_writable('./data/posts.php')){
			require('./data/posts.php');
			if(!isset($posts) || count($posts) < 1){
				$posts = array();
				$posts[0] = array('Welcome to ShoutCode. This is an automatic entry - feel free to remove it in your administration panel. Have fun!', 'korn19.ch', 'http://korn19.ch', '127.0.0.1', time());
				$openlog = fopen('./data/posts.php', 'w');
				fwrite($openlog, '<'.'?php $posts = '.var_export($posts, 1).'; ?'.'>');
				fclose($openlog);
				echo '<br />Added a dummy post successfully.';
				$openlog = fopen('./data/count-cache.php', 'w');
				fwrite($openlog, '1');
				fclose($openlog);
			}
		}
		else{
			die('/data/posts.php is not writable!');
		}
		require('./data/settings.php');
		$sc_usr_stngs['smilies_path'] = 'http://'.$_SERVER['HTTP_HOST'].str_replace('index.php', 'data/smilies/', $_SERVER['SCRIPT_NAME']);
		$openlog = fopen('./data/settings.php', 'w');
		fwrite($openlog, '<'.'?php $sc_usr_stngs = '.var_export($sc_usr_stngs, 1).'; ?'.'>');
		fclose($openlog);
		echo '<br />Added a smiley path. Please review it in case something went wrong (under Options &gt; Settings)
		<br />Done! ShoutCode has been successfully installed!
		<br />&raquo; <a href="?">Go to login</a>';
		@unlink(__FILE__);
	}
}
else{
	echo '<span style="color: #f00">Woops! Something went wrong. Please re-submit the form.</span>';
	$page = 3;
}
}
if($page == 3){

// Step 3: user inputs
	echo_style('Setting Up ShoutCode');
	if(isset($error) && $error != ''){
		echo '<b>Errors</b>'.$error;
	}
	echo '<p>Please enter the following information:</p>
<form action="'.$_SERVER['PHP_SELF'].'" method="post">
<table><tr>
	<td>Username
<br /><span style="font-size: 7pt">Will be used for the <br />administration login</span></td>
	<td style="vertical-align: middle"><input type="text" name="details[]" value="'.$details[0].'" maxlength="25" /></td>
</tr><tr>
	<td>Password</td>
	<td><input type="password" name="details[]" value="'.$details[1].'" maxlength="25" /></td>
</tr><tr>
	<td>Re-type password</td>
	<td><input type="password" name="details[]" value="'.$details[2].'" maxlength="25" /></td>
</tr><tr>
	<td>E-mail</td>
	<td><input type="text" name="details[]" value="'.$details[3].'" /></td>
</tr><tr>
	<td><input type="hidden" name="page" value="4" /></td>
	<td><input type="submit" class="submit" value=" Submit " /></td>
</tr></table></form>';
}
echo '<br />Step <b>'.htmlentities($page).'</b> of 4';
?>