<?php
if(!$functions_included){ die('Direct viewing of file is prohibited.'); }
deny_access(__FILE__);
if(!check_login()){ die('Not logged in!!'); }
echo_style('Debug', 1);
clearstatcache();

echo '<b>FILES</b><ul>';

// From: http://php.net/manual/en/function.disk-free-space.php#72281
function HumanSize($Bytes){
	$Type = array('', 'kilo', 'mega', 'giga', 'tera', 'peta', 'exa', 'zetta', 'yotta');
	$Index=0;
	while($Bytes>=1024){
		$Bytes /= 1024;
	    	$Index++;
	}
	$string = round($Bytes).' '.$Type[$Index].'bytes';
	if(preg_match('/^1[^0-9]/', $string)){
		return substr($string, 0, -1);
	}
	else{
		return $string;
	}
}

$files_to_check = array( // 0 - folder; 1 - file; 2 - writable file
	'show_posts.php' => 1,
	'style.css' => 1,
	'./mdu' => 0,
	'./mdu/login.php' => 1,
	'./mdu/options.php' => 1,
	'./mdu/process.php' => 1,
	'./mdu/templates.php' => 1,
	'./mdu/posts.php' => 1,
	'./mdu/main.php' => 1,
	'./mdu/settings.php' => 1,
	'./mdu/about.php' => 1,
	'./mdu/find.php' => 1,
	'./mdu/bbcode.php' => 1,
	'./mdu/ip.php' => 1,
	'./inc' => 0,
	'./inc/users.db.php' => 2,
	'./inc/functions.php' => 1,
	'./inc/post_functions.php' => 1,
	'./data' => 0,
	'./data/posts.php' => 2,
	'./data/count-cache.php' => 2,
	'./data/settings.php' => 2,
	'./data/template.php' => 2,
	'./data/ip.php' => 2,
	'./data/flood_db.php' => 2,
);

$lang = array(0 => 'Folder', 1 => 'File', 2 => 'File');
$errors = FALSE;
foreach($files_to_check as $file => $extent){
	echo '<li><b>'.$file.'</b>: ';
	if(file_exists($file)){
		if($extent == 2){
			if(is_writable($file)){
				echo 'exists and is writable.';
			}
			else{
				echo '<span style="color: #f00">is NOT writable!</span>';
				$errors = 1;
			}
		}
		else{
			echo 'exists.';
		}
	}
	else{
		echo '<span style="color: #f00">does NOT exist!</span>';
	}
	echo '</li>';
}
echo '</ul>
<br />&raquo; Report<br />';
if(!$errors){
	echo '<span style="color: #050">No errors have been found.</span>';
}
else{ echo '<span style="color: #f00">Errors have occured. Please notice the red lines.</span>'; }

if(file_exists('./mdu/installation.php')){
	echo '<br /><b>WARNING</b>: /mdu/installation.php still exists! Please delete it.';
}
if(file_exists('README.HTML')){
	echo '<br /><b>NOTICE</b>: ShoutCode detected that you have uploaded README.HTML. This is not required, but will do no harm.';
}

$posts = (int)file_get_contents('./data/count-cache.php');
echo '<br /><br /><b>SERVER SETTINGS &amp; STATISTICS</b>
<table>
 <tr><td>Server time</td><td>'.date('d M Y, H:i').'</td>
	<td>PHP version</td><td>'.phpversion().'</td></tr>
 <tr><td><a href="http://www.php.net/manual/en/security.globals.php">Register globals</a></td><td>';
print (ini_get('register_globals') == 1) ? '<span style="color: #f00">ON</span>' : 'Off';
echo '</td><td><a href="http://www.php.net/manual/en/security.magicquotes.what.php">Magic quotes</a></td><td>';
print (ini_get('magic_quotes_gpc') == 1) ? 'On' : 'Off';
echo '</td></tr>
<tr><td>DiskFreeSpace</td><td>'.HumanSize(disk_free_space(getcwd())).'*</td>
<td>Size of /data/posts.php</td><td>'.HumanSize(filesize('./data/posts.php')).'</td></tr>
<tr><td>Total posts</td><td>'.$posts.'</td>
<td>Average post size</td><td>';
if($posts > 0){
	echo HumanSize(filesize('./data/posts.php')/$posts);
}
else{ echo 'N/A'; }

echo '</td></tr></table>
<br />
<br />* The returned value of <a href="http://php.net/diskfreespace">DiskFreeSpace()</a> may not be accurate.
<br />&raquo; <a href="index.php">Back to main</a>';
?>