<?php
/// bbcode(): Replace BBCode with HTML
function bbcode($var){
 if(strpos($var, ']') !== false && strpos($var, '[') !== false){
	global $sc_usr_stngs;
	$bb = (string)$sc_usr_stngs['bbcode'];
	if(trim($bb) == ''){
		return $var;
	}
	if(strpos($bb, '1') !== false){
		$var = preg_replace('#\[b\](.*?)\[/b\]#si', '<b>\\1</b>', $var);
		$var = preg_replace('#\[i\](.*?)\[/i\]#si', '<i>\\1</i>', $var);
		$var = preg_replace('#\[u\](.*?)\[/u\]#si', '<span style="text-decoration: underline">\\1</span>', $var);
	}
	if(strpos($bb, '2') !== false){
		$var = preg_replace('#\[url\]([\w]+?://([\w\#$%&~/.\-;:=,?@\]+]+|\[(?!url=))*?)\[/url\]#is', '<a href="\\1">\\1</a>', $var);
		$var = preg_replace('#\[url\]((www|ftp)\.([\w\#$%&~/.\-;:=,?@\]+]+|\[(?!url=))*?)\[/url\]#is', '<a href="http://\\1">\\1</a>', $var);
		$var = preg_replace('#\[url=([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\]([^?\n\r\t].*?)\[/url\]#is', '<a href="\\1">\\2</a>', $var);
		$var = preg_replace('#\[url=((www|ftp)\.[\w\#$%&~/.\-;:=,?@\[\]+]*?)\]([^?\n\r\t].*?)\[/url\]#is', '<a href="http://\\1">\\3</a>', $var);
	}
	if(strpos($bb, '3') !== false){
		$var = preg_replace('#\[size=([1-2]?[0-9])\](.*?)\[/size\]#is', '<span style="font-size: \\1pt">\\2</span>', $var);
	}
	if(strpos($bb, '4') !== false){
		$var = preg_replace('#\[color=(\#[0-9A-F]{6})\](.*?)\[/color\]#si', '<span style="color: \\1">\\2</span>', $var);
		$var = preg_replace('#\[color=(\#[0-9A-F]{3})\](.*?)\[/color\]#si', '<span style="color: \\1">\\2</span>', $var);
	}
}
return $var;
}

/// change_input: Put HTML to its entities
function change_input($string){

	global $utf8_error;
	$string = trim($string);
	if(get_magic_quotes_gpc()){
		$string = stripslashes($string);
	}
####
# Text to UTF-8 or HTML Entities tool Copyright (c) 2006 - Brian Huisman (GreyWyvern)
# This script is licenced under the BSD licence: http://www.greywyvern.com/code/bsd
# Modification to a PHP function and bug fixing: 2008, 2009 - http://korn19.ch
####
/*
Solely UTF-8 input may be sent, i.e. the internet user may only send 
his data by using UTF-8 as encoding.
The preg_match() line below will fail otherwise
and the function will return nothing.
Therefore, use accept-charset="utf-8" on your SC <form>s.
*/


	$char = ''; $string_copy = $string;
	while(strlen($string) > 0){
		preg_match('/^(.)(.*)$/us', $string, $match);
		$test = utf8_decode($match[1]);
		if($test != '?'){
			$char .= htmlentities($test);
		}
		else if(strlen($match[1]) > 1){
			$char .= '&#'.uniord($match[1]).';';
		}
		else{
			$char .= htmlentities($match[1]);
		}
		$string = $match[2];
	}
	// check if something went wrong.
	if(strlen($char) < strlen($string_copy)){
		$utf8_error = true;
		return '';
	}
	return $char;
}

function UniOrd($c){
	$ud = 0;
	if (ord($c{0}) >= 0 && ord($c{0}) <= 127) $ud = ord($c{0});
	if (ord($c{0}) >= 192 && ord($c{0}) <= 223) $ud = (ord($c{0})-192)*64 + (ord($c{1})-128);
	if (ord($c{0}) >= 224 && ord($c{0}) <= 239) $ud = (ord($c{0})-224)*4096 + (ord($c{1})-128)*64 + (ord($c{2})-128);
	if (ord($c{0}) >= 240 && ord($c{0}) <= 247) $ud = (ord($c{0})-240)*262144 + (ord($c{1})-128)*4096 + (ord($c{2})-128)*64 + (ord($c{3})-128);
	if (ord($c{0}) >= 248 && ord($c{0}) <= 251) $ud = (ord($c{0})-248)*16777216 + (ord($c{1})-128)*262144 + (ord($c{2})-128)*4096 + (ord($c{3})-128)*64 + (ord($c{4})-128);
	if (ord($c{0}) >= 252 && ord($c{0}) <= 253) $ud = (ord($c{0})-252)*1073741824 + (ord($c{1})-128)*16777216 + (ord($c{2})-128)*262144 + (ord($c{3})-128)*4096 + (ord($c{4})-128)*64 + (ord($c{5})-128);
	if (ord($c{0}) >= 254 && ord($c{0}) <= 255) $ud = false; // error
	return $ud;
}
# END CODE


/// smilies(): Replace to smilies
function smilies($input){
	global $sc_usr_stngs;
	if(!isset($sc_usr_stngs['smilies']) || !is_array($sc_usr_stngs['smilies']) || count($sc_usr_stngs['smilies']) == 0){
		return $input;
	}
	else{
		foreach($sc_usr_stngs['smilies'] as $smiley){
			if(trim($smiley) != ''){
				$input = str_replace(':'.$smiley.':', '<img src="'.$sc_usr_stngs['smilies_path'].$smiley.'.gif" alt="'.$smiley.'" />', $input);
			}
		}
		return $input;
	}
}

/// utf8_strlen(): Check length of a string with support for non-ASCII chars
function utf8_strlen($str){
	return strlen(utf8_decode($str));
}
?>