<?php
$functions_included = true;

/* Table of Contents
> get_users()
> check_login()
> timer_start()
> timer_end()
> deny_access()
> convert_pass()
> echo_style()
> check_file()
> valid_ban()
*/


# get_users()
# gets the ShoutCode users, returns them in $users or outputs various errors
function get_users(){
	global $users;
	if(!file_exists('./inc/users.db.php')){
		$users = 1;
		return false;
	}
	else{
		require('./inc/users.db.php');
		if(!isset($users) || count($users) < 1){
			$users = 2;
			return false;
		}
		else{
			return true;
		}
	}
}

# check_login()
# checks if the user is logged in
function check_login(){
	global $users;
	if(!isset($users)){
		echo '$users is not set!';
		return false;
	}
	else{
		if(!isset($_COOKIE['sc_user']) || !isset($_COOKIE['sc_pass'])){
			return false;
		}
		else{
// $users = array('name' => array('0' => pass, '1' => perm, '2' => joined, '3' => lastlogin, '4' => mail))
			if(isset($users[strtolower($_COOKIE['sc_user'])])
				&& $_COOKIE['sc_pass'] === $users[strtolower($_COOKIE['sc_user'])][0]){
				return true;
			}
			else{
				return false;
			}
		}
	}
}

# timer_start(), timer_end()
# get in how many secs the page got generated and return the secs
function timer_start(){
	global $timer;
	$timer = microtime(true);
}
function timer_end(){
	global $timer;
	$timer = microtime(true)-$timer;
	$timer = explode('.', $timer); // code-wise ugly but it works ;)
	if($timer[0] > 0){
		$timer = round($timer[0].'.'.$timer[1], 1);
	}
	else{
		$i = 0;
		while($timer[1][$i] == '0' && $i < (strlen($timer[1])-1)){
			$i++;
		}
		$timer = round('0.'.$timer[1], ++$i);
	}
	return $timer;
}

# deny_access()
# deny direct access to files that are called through include()/require(), redirect to top-level index.php
function deny_access($file){
	if($_SERVER['SCRIPT_FILENAME'] == $file){
		header('../index.php');
		exit;
	}
}

# convert_pass()
# convert the raw inputted password to the final md5 hash that gets stored in the DB
function convert_pass($pass){
	$pass = strlen($pass).$pass.'141421356237';
	$pass = md5(md5($pass).md5($pass));
	$pass = strrev($pass);
	return md5($pass);
}

# echo_style()
# used for the administration, displays the TITLE with some HTML
function echo_style($title, $logged=false){
	if($logged){
		global $menu, $mdu; // <-- defined in index.php
		$output = '';
		foreach($menu as $link => $name){
			if($mdu == $link){
				$output .= ' | <b>'.$name.'</b>';
			}
			else{
				$output .= ' | <a href="?do='.$link.'">'.$name.'</a>';
			}
		}
		echo '<div class="wrptitle">'.$title.'</div><div class="loggedmenu">'.substr($output, 2).'</div>';
	}
	else{
		echo '<div class="wrptitle">'.$title.'</div>';
	}
	echo '<div class="wrapper">';
}

# check_file()
# Check if a file exists (and if writable) - validation before writing/including files.
function check_file($file, $is_writable=false){
	if(file_exists($file)){
		if($is_writable){
			if(is_writable($file)){
				return true;
			}
			else{
				return false;
			}
		}
		else{
			return true;
		}
	}
	else{
		return false;
	}
}

# valid_ban()
# check if the banned IP (or IP range) is a valid input
function valid_ban($ip){
	if(preg_match('/^([0-9]{1,3}|\*{1})(\.([0-9]{1,3}|\*{1})){3}$/', $ip)){
		$ip = explode('.', $ip);
		$asterisk = false;
		for($i = 0; $i < 4; $i++){
			if(!$asterisk && $ip[$i] == '*'){
				$asterisk = true;
			}
			else if($asterisk && $ip[$i] != '*'){
				return false;
			}
		}
		return true;
	}
	else{ return false; }
}
?>