<?php
/*
 * Folder indexer https://jalu.ch/coding/folder-indexer.php
 * Contact: https://jalu.ch/misc/contact.php
*/

// Add a password if you want. At least 3 characters or it will be ignored.
// You can delete this line to not have a password.
$password = 'password';

// Add file types to filter by. Must be exactly as the page displays them, e.g. $filetypes = ['Directory', 'JPEG', 'PHP'];
// If empty, all file types are shown.
$filetypes = [];

// -------------------------------------------------------------
// Don't edit below this line unless you know what you're doing!


if (isset($_GET['out'])) {
  setcookie('folder_auth', 'out', time() - 999);
  header('location:' . $_SERVER['PHP_SELF']);
  exit;
}

if (isset($_GET['imgfo'])) {
  header('Content-Type: image/gif');
  echo base64_decode('R0lGODlhEAAQAPcAAIx7WoyEa5SEa5SMY5SMa5SMhJyEOZyEQpyMc5yUhJycjKWUWqWcjK2ca62tpa2trbWUMbWUObW1rbW1tb2cOb2lY8alQsatSsbGxs7Ozs7W1tatQta1c9a9Wt69Qt69St69Ut7Otd7e3ufGY+fOY+fOa+fOe+fOhOfOnOfWnOfWtefWvefe3ufn5+/GSu/OWu/OY+/Oc+/Wc+/We+/WhO/WjO/WlO/ehO/elO/enO/ere/nre/v7/fOY/fWY/fWc/fWe/fea/fepfferffnjPfnlPfnnPfnpffnrffntffvzvfv1vf37/f39//Wa//ec//ee//ne//ve//vhP/vjP/3jP/3lP/3nP/3pf/3tf/3vf/3xv/35//37///lP//nP//pf//rf//tf//vf//xv//3v///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////ywAAAAAEAAQAAAI4gDNCDTDhcfAgweX2EhxREcIJmZ4KFmixKBAHVmwYAmDAkUOHUJwmOAQgmAOLF+8fLlSwgQNGil0HKmggcsOL1aiyCChpIzPMlmSLMjAw0SJGDiOaNkyhukWJEYEiOhiwsaYMFizYr1yQ0ALMyNqqLzyJWVZL1RGEIAIgoiVtzjfvqXSIUETsDimUNHLl8peCw7ugpgRJcoUw4inQIkwQeCIGVCiQIk8GQoMDwYwCDQR48mPHz1cbIhwAECBB1/NnBjxwQKEAwESPMgggsddgSEaBFAwgTaT2wjNtGgBMfjBgAAAOw%3D%3D');
  exit;
} else if (isset($_GET['imgfi'])) {
  header('Content-Type: image/gif');
  echo base64_decode('R0lGODlhEAAQAKL/AP///zk5OWtra4yMjMDAwM7Ozufn5wAAACH5BAEAAAQALAAAAAAQABAAAAM5SLrcvuMVQGsxsc1KJ9ZcVxREpmxhoAYMGipCG3JGvLizfc6cTuAhH7An41GExmPR6CsJnlAoa5EAADs%3D');
  exit;
}

if (isset($password) && strlen($password) > 2) {
  handle_authentication($password);
}

$config = array();
if (isset($_GET['hidden_files'])) {
  $config['show_hidden_files'] = (bool) $_GET['hidden_files'];
} else {
  $config['show_hidden_files'] = true;
}

if (isset($_GET['folders'])) {
  $config['show_folders'] = (bool) $_GET['folders'];
} else {
  $config['show_folders'] = true;
}

if (!isset($filetypes) || !is_array($filetypes)) {
  $filetypes = [];
}


echo '<html><head><style type="text/css">
<!--
body { font-family: Verdana; font-size: 10pt; }
li { list-style-image: url(?imgfi); }
ul#Directory li { list-style-image: url(?imgfo); }
ul.menu li { list-style-image: none; }
-->
</style><title>Folder contents</title></head><body>';

$options = '<form action="' . $_SERVER['PHP_SELF'] . '" method="get">
 <fieldset style="border: 1px solid #000; width: 40%"><legend>Options</legend>
Show folders <select name="folders">
 <option value="1">Yes</option>
 <option value="0">No</option></select>
<br /> Show hidden files <select name="hidden_files">
 <option value="1">Yes</option>
 <option value="0">No</option></select>
<br /> <input type="submit" value="Change" />
</fieldset></form>';

$dir = getcwd();
if (!is_dir($dir)) {
  echo 'Error! Cannot get current directory';
  exit;
}

$files = [];
if ($dh = opendir($dir)) {
  while (($file = readdir($dh)) !== false) {
    if ($file === '.' || $file === '..' || (!$config['show_folders'] && is_dir($file))) {
      continue;
    }

    $filetype = is_dir($file)
      ? 'Directory'
      : strtoupper(preg_replace('/^.*\.(.*?)$/', '\\1', $file));
    if ($filetype === strtoupper($file)) {
      $filetype = 'Plain';
    }

    if (!$config['show_hidden_files'] && strtoupper($file) === '.' . $filetype) {
      continue;
    } else if (!empty($filetypes) && !in_array($filetype, $filetypes)) {
      continue;
    }

    if (!isset($files[$filetype])) {
      $files[$filetype] = [];
    }
    $files[$filetype][] = $file;
  }
  closedir($dh);
}
uksort($files, function ($a, $b) {
  if ($a === $b) {
    return 0;
  } else if ($a === 'Directory') {
    return -1;
  } else if ($b === 'Directory') {
    return 1;
  }
  return $a <=> $b;
});

$menu = '<ul class="menu">';
$content = '';
$total_files = 0;
$total_dir = 0;
foreach ($files as $filetype => $file_array) {
  if ($filetype === 'Directory') {
    $menu .= '<li><a href="#Directory">Directories (' . count($file_array) . ')</a></li>';
    $content .= '<b>Directories</b><ul id="Directory">';
    $total_dir = count($file_array);
  } else {
    $menu .= '<li><a href="#' . $filetype . '">' . $filetype . ' files (' . count($file_array) . ')</a></li>';
    $content .= "<b>$filetype files</b><ul id=\"$filetype\">";
    $total_files += count($file_array);
  }

  foreach ($file_array as $file) {
    $content .= "<li><a href=\"$file\">$file</a>";
  }
  $content .= '</ul>';
}
echo '<h1 style="font-size: 16pt">' . $total_files . ' files, ' . $total_dir . ' directories</h1>' . $options . $menu . '</ul>' . $content;


function handle_authentication($password) {
  if (isset($_POST['pass'])) {
    if ($_POST['pass'] === $password) {
      setcookie('folder_auth', password_hash($password, PASSWORD_DEFAULT), time() + 9999);
      header('location:' . $_SERVER['PHP_SELF']);
      exit;
    } else {
      echo 'Password incorrect';
      exit;
    }
  }

  if (!isset($_COOKIE['folder_auth']) || !password_verify($password, $_COOKIE['folder_auth'])) {
    setcookie('folder_auth', 'removed', time() - 999);
    echo '<form action="' . $_SERVER['PHP_SELF'] . '" method="post">
Password required: <input type="password" name="pass" maxlength="125" /> <input type="submit" value="Log in" /></form>';
    exit;
  }
}

$log_out_link = isset($password) && strlen($password) > 2
  ? "<a href='?out'>Log out</a> &middot; "
  : "";

echo <<<HTML
<p style="text-align: right">$log_out_link Folder indexer by <a href="https://jalu.ch">jalu.ch</a>.</p>
</body></html>
HTML;
// comment to ensure there is a line after heredoc syntax